#include <stddef.h>
#include <locale.h>
#include <langinfo.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>

void main()
{
  FILE *f;
  char s[1000];
    
  printf("Program start. No locales set yet.\n");
  printf("Testing: messages locale = %s\n\n", nl_langinfo(_NL_LOCALE_NAME(LC_MESSAGES)));

  printf("Setting locale to empty string.\n");
  setlocale (LC_ALL, "");
  printf("Testing: messages locale = %s\n\n", nl_langinfo(_NL_LOCALE_NAME(LC_MESSAGES)));

  printf("Setting all locales to en_GB.UTF-8.\n");
  setlocale (LC_ALL, "en_GB.UTF-8");
  printf("Testing: messages locale = %s\n\n", nl_langinfo(_NL_LOCALE_NAME(LC_MESSAGES)));

  printf("Setting all locales to en_US.UTF-8.\n");
  setlocale (LC_ALL, "en_US.UTF-8");
  printf("Testing: Messages locale = %s\n\n", nl_langinfo(_NL_LOCALE_NAME(LC_MESSAGES)));
  
  printf("Language name with region: %s\n", nl_langinfo(_NL_IDENTIFICATION_LANGUAGE));
  printf("Currency symbol: %s\n", nl_langinfo(CRNCYSTR));
  printf("Date format: %s\n", nl_langinfo(D_FMT));
  printf("Time format: %s\n", nl_langinfo(T_FMT));
  printf("Date/time format: %s\n", nl_langinfo(D_T_FMT));
  printf("First day of the week: %s\n", nl_langinfo(DAY_1));

  printf("Time zone: ");
  f=fopen("/etc/timezone", "r");
  while (fgets(s, 1000, f)!=NULL)
    printf("%s", s);
  fclose(f);

  printf("Number format: %'.6f\n", 1234567890.012345);
  
  return;
}
